import { FormEvent, SetStateAction } from 'react'
import Form from '../ui/Form'
import FormHeader from '../ui/FormHeader'
import FormInput from '../ui/FormInput'
import FormNotify from '../ui/FormNotify'
import FromBtn from '../ui/FromBtn'
import MainWrapper from '../ui/MainWrapper'

interface IProps {
	userName: string
	setUserName: (value: SetStateAction<string>) => void
	password: string
	setPassword: (value: SetStateAction<string>) => void
	onSubmit: (e: FormEvent<HTMLFormElement>) => void
}

const LoginBlock = ({
	userName,
	setUserName,
	password,
	setPassword,
	onSubmit,
}: IProps) => {
	return (
		<MainWrapper>
			<Form onSubmit={onSubmit}>
				<FormHeader title='Логин' />

				<FormInput
					value={userName}
					placeholder={'name'}
					id={'name'}
					type={'text'}
					onChange={e => setUserName(e.target.value)}
				/>

				<FormInput
					value={password}
					placeholder={'password'}
					id={'password'}
					type={'password'}
					onChange={e => setPassword(e.target.value)}
				/>

				<FromBtn title='Войти' />

				<FormNotify
					text={'Аккаунта нет?'}
					linkTxt={'Регистрация'}
					href={'/auth/registration'}
				/>
			</Form>
		</MainWrapper>
	)
}

export default LoginBlock
