import { FormEvent, SetStateAction } from 'react'
import Form from '../ui/Form'
import FormHeader from '../ui/FormHeader'
import FormInput from '../ui/FormInput'
import FormNotify from '../ui/FormNotify'
import FromBtn from '../ui/FromBtn'
import MainWrapper from '../ui/MainWrapper'

interface IProps {
	userName: string
	setUserName: (value: SetStateAction<string>) => void
	password: string
	setPassword: (value: SetStateAction<string>) => void
	displayName: string
	setDisplayName: (value: SetStateAction<string>) => void
	onSubmit: (e: FormEvent<HTMLFormElement>) => void
}

const RegistrationBlock = ({
	userName,
	setUserName,
	password,
	setPassword,
	displayName,
	setDisplayName,
	onSubmit,
}: IProps) => {
	return (
		<MainWrapper>
			<Form onSubmit={onSubmit}>
				<FormHeader title='Регистрация' />

				<FormInput
					value={userName}
					placeholder={'name'}
					id={'name'}
					type={'text'}
					onChange={e => setUserName(e.target.value)}
				/>

				<FormInput
					value={displayName}
					placeholder={'displayName'}
					id={'displayName'}
					type={'text'}
					onChange={e => setDisplayName(e.target.value)}
				/>

				<FormInput
					value={password}
					placeholder={'password'}
					id={'password'}
					type={'password'}
					onChange={e => setPassword(e.target.value)}
				/>

				<FromBtn title='Регистрация' />

				<FormNotify
					text={'Уже есть аккаунт?'}
					linkTxt={'Войти'}
					href={'/auth/login'}
				/>
			</Form>
		</MainWrapper>
	)
}

export default RegistrationBlock
