'use client'

import { axiosApiClient } from '@/helpers/axiosClient'
import { useUserStore } from '@/store/userStore'
import { useRouter } from 'next/navigation'
import { FormEvent, useState } from 'react'
import LoginBlock from '../blocks/LoginBlock'

const Login = () => {
	const router = useRouter()

	const { user, setUser } = useUserStore()

	const [userName, setUserName] = useState(user?.userName ?? '')
	const [password, setPassword] = useState('')

	const onSubmit = async (e: FormEvent) => {
		e.preventDefault()

		const newUser = {
			userName,
			password,
		}

		const { data } = await axiosApiClient.post('/auth/login', newUser)
		setUser(data)

		router.push('/')
	}

	return (
		<LoginBlock
			userName={userName}
			setUserName={setUserName}
			password={password}
			setPassword={setPassword}
			onSubmit={onSubmit}
		/>
	)
}

export default Login
