'use client'

import { axiosApiClient } from '@/helpers/axiosClient'
import { useUserStore } from '@/store/userStore'
import { useRouter } from 'next/navigation'
import { FormEvent, useState } from 'react'
import RegistrationBlock from '../blocks/RegistrationBlock'

const Registration = () => {
	const router = useRouter()

	const { user, setUser } = useUserStore()

	const [userName, setUserName] = useState(user?.userName ?? '')
	const [displayName, setDisplayName] = useState(user?.displayName ?? '')
	const [password, setPassword] = useState('')

	const onSubmit = async (e: FormEvent) => {
		e.preventDefault()

		const newUser = {
			userName,
			displayName,
			password,
		}
		const { data } = await axiosApiClient.post('/auth/register', newUser)
		setUser(data)

		router.push('/')
	}

	return (
		<RegistrationBlock
			userName={userName}
			setUserName={setUserName}
			password={password}
			setPassword={setPassword}
			displayName={displayName}
			setDisplayName={setDisplayName}
			onSubmit={onSubmit}
		/>
	)
}

export default Registration
