import { FormEvent, ReactNode } from 'react'

interface IProps {
	children: ReactNode
	classNames?: string
	onSubmit: (e: FormEvent<HTMLFormElement>) => void
}

const Form = ({ children, classNames, onSubmit }: IProps) => {
	return (
		<form
			onSubmit={onSubmit}
			className={`
        ${classNames}
        w-[450px] h-[350px] bg-amber-50 rounded-2xl
        p-5 text-center flex flex-col justify-between
      `}
		>
			{children}
		</form>
	)
}

export default Form
