import { ChangeEvent } from 'react'

interface IProps {
	value: string
	placeholder: string
	id: string
	type: string
	onChange?: (e: ChangeEvent<HTMLInputElement>) => void
}

const FormInput = ({ type, id, value, onChange, placeholder }: IProps) => {
	return (
		<input
			type={type}
			id={id}
			value={value}
			placeholder={placeholder}
			onChange={onChange}
			className='p-2 h-10 rounded-xl w-full text-gray-700 border-2 border-blue-200'
		/>
	)
}

export default FormInput
