import Link from 'next/link'

interface IProps {
	text: string
	linkTxt: string
	href: string
}

const FormNotify = ({ text, linkTxt, href }: IProps) => {
	return (
		<p className='text-gray-600'>
			{text}
			<Link className='ml-4 text-cyan-300' href={href}>
				{linkTxt}
			</Link>
		</p>
	)
}

export default FormNotify
