'use client'

import { ReactNode } from 'react'
import { ToastContainer } from 'react-toastify'

type Props = {
	children: ReactNode
}

const ToastifyProvider = ({ children }: Props) => {
	return (
		<>
			<ToastContainer
				position='top-right'
				autoClose={5000}
				hideProgressBar={false}
				newestOnTop={false}
				closeOnClick={false}
				rtl={false}
				pauseOnFocusLoss
				draggable
				pauseOnHover
				theme='light'
			/>

			{children}
		</>
	)
}

export default ToastifyProvider
