import { TUser } from '@/interfaces/user'
import { create } from 'zustand'
import { createJSONStorage, persist } from 'zustand/middleware'

type TSlice = {
	user?: TUser | null
	setUser: (u: TUser) => void
	clearUser: () => void
}

export const useUserStore = create<TSlice>()(
	persist(
		set => ({
			user: null,
			setUser: u => set({ user: u }),
			clearUser: () => set({ user: null }),
		}),
		{
			name: 'user-store',
			storage: createJSONStorage(() => localStorage),
		}
	)
)
