import {
  CanActivate,
  ExecutionContext,
  Injectable,
  UnauthorizedException,
} from '@nestjs/common';
import { Request } from 'express';
import { appDataSource } from 'src/db/dataSource';
import { User } from 'src/user/entities/user.entity';

@Injectable()
export class AuthGuard implements CanActivate {
  async canActivate(context: ExecutionContext): Promise<boolean> {
    const userRepo = appDataSource.getRepository(User);

    const request: Request = context.switchToHttp().getRequest();
    const authHeader = request.headers['authorization'];

    if (!authHeader) {
      throw new UnauthorizedException('Токена нет');
    }

    try {
      const token = authHeader;

      const user = await userRepo.findOneBy({ token });

      if (!user) {
        throw new UnauthorizedException('Юзера нет');
      }

      return true;
    } catch {
      throw new UnauthorizedException('Ошибка авторизации');
    }
  }
}
