import { randomUUID } from 'crypto';
import { diskStorage } from 'multer';
import * as path from 'path';

const rootPath = path.resolve(process.cwd());
const uploadPath = path.join(rootPath, 'uploads');

export const storage = {
  storage: diskStorage({
    destination: (req, file, cb) => {
      cb(null, uploadPath);
    },
    filename: (req, file, cb) => {
      cb(null, randomUUID() + path.extname(file.originalname));
    },
  }),
};
