import * as dotenv from 'dotenv';
import * as path from 'path';
import { Category } from 'src/categories/entities/category.entity';
import { Product } from 'src/products/entity/product';
import { User } from 'src/user/entities/user.entity';
import { DataSource, DataSourceOptions } from 'typeorm';
import { SeederOptions } from 'typeorm-extension';
import { categoryFactory } from './factories/category.factory';
import { productFactory } from './factories/product.factory';
import { userFactory } from './factories/user.factory';
import MainSeeder from './seeders/main.seeder';

dotenv.config({ path: path.resolve(process.cwd(), '.env') });

const options: DataSourceOptions & SeederOptions = {
  type: 'postgres',
  host: process.env.DB_HOST,
  port: Number(process.env.DB_PORT),
  username: process.env.DB_USER,
  password: process.env.DB_PASS,
  database: process.env.DB_NAME,
  synchronize: true,
  logging: true,
  entities: [User, Category, Product],
  seeds: [MainSeeder],
  factories: [userFactory, categoryFactory, productFactory],
};

export const appDataSource = new DataSource(options);
