import { faker } from '@faker-js/faker';
import { Product } from 'src/products/entity/product';
import { setSeederFactory } from 'typeorm-extension';

export const productFactory = setSeederFactory(Product, () => {
  const product = new Product();

  product.title = faker.commerce.productName();
  product.price = faker.number.int({ min: 100, max: 2000 });
  product.description = faker.lorem.sentence();
  product.image = 'testProduct.jpg';

  return product;
});
