import { faker } from '@faker-js/faker';
import * as bcrypt from 'bcrypt';
import { User } from 'src/user/entities/user.entity';
import { setSeederFactory } from 'typeorm-extension';

const SALT_WORK_FACTOR = 10;

export const userFactory = setSeederFactory(User, async () => {
  const user = new User();

  user.displayName = faker.person.firstName();
  user.userName = faker.internet.username();

  const salt = await bcrypt.genSalt(SALT_WORK_FACTOR);
  user.password = await bcrypt.hash('password', salt);

  return user;
});
