import { faker } from '@faker-js/faker';
import { Category } from 'src/categories/entities/category.entity';
import { Product } from 'src/products/entity/product';
import { User } from 'src/user/entities/user.entity';
import { DataSource } from 'typeorm';
import { Seeder, SeederFactoryManager } from 'typeorm-extension';

export default class MainSeeder implements Seeder {
  public async run(
    _dataSource: DataSource,
    factoryManager: SeederFactoryManager,
  ): Promise<void> {
    const userFactory = factoryManager.get(User);
    const productFactory = factoryManager.get(Product);
    const categoryFactory = factoryManager.get(Category);

    await userFactory.saveMany(20);

    const categories = await categoryFactory.saveMany(10);

    await productFactory.saveMany(10, {
      category: faker.helpers.arrayElement(categories),
    });
  }
}
