import { Type } from 'class-transformer';
import { IsNumber, IsOptional, IsString } from 'class-validator';

export class CreateProductDto {
  @IsString({ message: 'Title must have be string' })
  title: string;

  @IsOptional()
  @IsString({ message: 'Description must have be string' })
  description?: string;

  @Type(() => Number)
  @IsNumber()
  price: number;

  @Type(() => Number)
  @IsNumber()
  categoryId: number;
}
