import { Injectable, NotFoundException } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Category } from 'src/categories/entities/category.entity';
import { Repository } from 'typeorm';
import { CreateProductDto } from './dto/create-product.dto';
import { Product } from './entity/product';

@Injectable()
export class ProductsService {
  constructor(
    @InjectRepository(Product)
    private readonly productRepo: Repository<Product>,
    @InjectRepository(Category)
    private readonly categoryRepo: Repository<Category>,
  ) {}

  async create(
    createProductDto: CreateProductDto,
    fileName?: string,
  ): Promise<Product> {
    const category = await this.categoryRepo.findOneBy({
      id: createProductDto.categoryId,
    });

    if (!category) throw new NotFoundException('Category not found');

    const product = this.productRepo.create({
      ...createProductDto,
      image: fileName,
      category,
    });

    return await this.productRepo.save(product);
  }

  async findAll(): Promise<Product[]> {
    return await this.productRepo.find({
      relations: {
        category: true,
      },
    });
  }
}
