import { IsOptional, IsString } from 'class-validator';

export class CreateUserDto {
  @IsString()
  userName: string;

  @IsOptional()
  @IsString()
  displayName: string;

  @IsOptional()
  @IsString()
  role?: 'user' | 'admin';

  @IsString()
  password: string;
}
