import * as bcrypt from 'bcrypt';
import { Column, Entity, PrimaryGeneratedColumn } from 'typeorm';

@Entity({ name: 'users' })
export class User {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ unique: true })
  userName: string;

  @Column({ nullable: true })
  displayName?: string;

  @Column({ default: 'user' })
  role?: 'user' | 'admin';

  @Column()
  password: string;

  @Column({ type: 'varchar', nullable: true })
  token: string | null;

  async comparePassword(password: string): Promise<boolean> {
    return await bcrypt.compare(password, this.password);
  }

  generateToken() {
    this.token = crypto.randomUUID();
  }
}
