import { IngredientNames } from '@/interfaces/Ingredients';
import './BuildControl.css';

interface Props {
    type: IngredientNames
    lessHandler: VoidFunction
    moreHandler: VoidFunction
    disabled: boolean;
}

const BuildControl = ({disabled, type, moreHandler, lessHandler}: Props) => {
    return (
        <div className="BuildControl">
            <div className="Label">{type}</div>
            <button className="Less" disabled={disabled} onClick={lessHandler}>Less</button>
            <button className="More" onClick={moreHandler}>More</button>
        </div>
    );
}

export default BuildControl;
