import { IngredientNames } from '@/interfaces/Ingredients';
import BuildControl from './BuildControl/BuildControl';
import { useAppDispatch, useAppSelector } from '@/store/hooks';
import { lessHandler, moreHandler, setOpen } from '@/store/slice/burger.slice';
import './BuildControls.css';


const BuildControls = () => {
    const dispatch = useAppDispatch()

    const {ingredients, totalPrice, purchasable} = useAppSelector(state => state.burger)

    const ingKeys = Object.keys(ingredients)

    return (
        <div className='BuildControls'>
            <p>Current Price: <strong>{totalPrice} ₸</strong></p>

            {
                ingKeys.map((ingKey, index) => (
                    <BuildControl 
                        key={ingKey + index} 
                        type={ingKey as IngredientNames}
                        moreHandler={() => dispatch(moreHandler(ingKey as IngredientNames))}
                        lessHandler={() => dispatch(lessHandler(ingKey as IngredientNames))}
                        disabled={!Boolean(ingredients[ingKey as IngredientNames])}
                    />
                ))
            }

            <button 
                className="OrderButton" 
                disabled={!purchasable}
                onClick={() => dispatch(setOpen(true))}
            >
                ORDER NOW
            </button>
        </div>
    );
}

export default BuildControls;
