import { ReactNode } from 'react';
import { IngredientNames } from '@/interfaces/Ingredients';
import Ingredient from './Ingredient/Ingredient';
import { useAppSelector } from '@/store/hooks';
import './Burger.css';

const Burger = () => {
    const {ingredients} = useAppSelector(state => state.burger)

    const ingredientKeys = Object.keys(ingredients)
    
    let ingList: ReactNode[] = []

    ingredientKeys.forEach(ingKey => {
        let amount = ingredients[ingKey as IngredientNames]
        
        for(let i = 0; i < amount; i++) {
            ingList.push(
                <Ingredient key={ingKey + 1} type={ingKey as IngredientNames}/>
            )
        }
    })

    return (
        <div className='Burger'>
            <Ingredient type={'bread-top'}/>
            {ingList}
            <Ingredient type={'bread-bottom'}/>
        </div>
    );
}

export default Burger;
