import { IngredientNames } from '@/interfaces/Ingredients';
import './Ingredient.css';

interface Props {
    type: 'bread-bottom' | 'bread-top' | IngredientNames
}

const Ingredient = ({type}: Props) => {
    switch (type) {
        case 'bread-bottom':
          return <div className="BreadBottom" />;
        case 'bread-top':
          return (
            <div className="BreadTop">
              <div className="Seeds1"/>
              <div className="Seeds2"/>
            </div>
          );
        case 'meat':
          return <div className="Meat" />;
        case 'cheese':
          return <div className="Cheese" />;
        case 'salad':
          return <div className="Salad" />;
        case 'chicken':
          return <div className="Chicken" />;
        default:
          return null;
      }
}

export default Ingredient;
