import { IngredientNames } from '@/interfaces/Ingredients';
import { useAppSelector } from '@/store/hooks';
import { useNavigate } from 'react-router-dom';

const OrderSummary = () => {
    const navigate = useNavigate()

    const {ingredients, totalPrice} = useAppSelector(state => state.burger)

    const ingredientSummary = Object.keys(ingredients)
                                    .map((ingKey) => {
                                        return (
                                            <li key={ingKey}>
                                                <span style={{textTransform: 'capitalize'}}>
                                                    {ingKey}
                                                </span>: {ingredients[ingKey as IngredientNames]}
                                            </li> 
                                        )
                                    })

    return (
        <>
           <h3>Your order</h3>
           <p>A delicious burger with the following ingredients:</p>
           <ul>
               {ingredientSummary}
           </ul>
           <p><strong>Total Price: {totalPrice} ₸</strong></p>
           <button onClick={() => navigate('/checkout')}>
                Continue
           </button>
       </>
    )
}

export default OrderSummary