import Burger from "@/components/Burger/Burger";
import Button from "@/components/UI/Button/Button";
import { useNavigate } from "react-router-dom";
import "./CheckoutSummary.css";


const CheckoutSummary = () => {
    const navigate = useNavigate();

    return (
        <div className="CheckoutSummary">
            <h1>We hope it tastes well!</h1>

            <div style={{ width: "100%", margin: "auto" }}>
                <Burger />
            </div>

            <Button
                btnType="Danger"
                click={() => navigate(-1)}
            >
                CANCEL
            </Button>

            <Button
                btnType="Success"
                click={() => navigate('contact-data')}
            >
                CONTINUE
            </Button>
        </div>
    );
};

export default CheckoutSummary;
