import type { MouseEventHandler, ReactNode } from "react";
import "./Button.css";

interface Props {
  click: MouseEventHandler<HTMLButtonElement>;
  btnType: "Success" | "Danger";
  children: ReactNode;
}

const Button = (props: Props) => (
  <button onClick={props.click} className={["Button", props.btnType].join(" ")}>
    {props.children}
  </button>
);

export default Button;
