import { ReactNode } from "react"
import Backdrop from "../Backdrop/Backdrop"
import './Modal.css'

type TProps = {
    children: ReactNode
    open: boolean
}

const Modal = ({open, children}: TProps) => {
  return open ? (
    <>
        <Backdrop/>
        <div className="Modal">
            {children}
        </div>
    </>
  ) : null
}

export default Modal