import Button from "@/components/UI/Button/Button";
import Spinner from "@/components/UI/Spinner/Spinner";
import { useAppDispatch, useAppSelector } from "@/store/hooks";
import { postContactData, setCustomer } from "@/store/slice/contactData.slice";
import { useEffect } from "react";
import "./ContactData.css";

const ContactData = () => {
  const dispatch = useAppDispatch()

  const {
    burger: {
      ingredients
    }, 
    contactData: {
      loading, 
      customer,
      error
    }
  } = useAppSelector(state => state)

  useEffect(() => {
    if(error) {
      console.log(error)
    }
  }, [error])

  const onChangeCustomer = (e: React.FormEvent<HTMLInputElement>) => {
      const {value, name} = e.currentTarget
      dispatch(setCustomer({value, name}))
  }

  const onOrder = async (e: React.SyntheticEvent<HTMLFormElement>) => {
    e.preventDefault()

    const data = {
      contact: customer,
      ingredients: ingredients
    }

    dispatch(postContactData(data))
  }

  if(loading) return <Spinner/>

  return (
    <div className="ContactData">
      <h4>Enter your Contact Data</h4>

      <form onSubmit={onOrder}>
        <input
            className="Input"
            type="text"
            name="name"
            placeholder="Your Name"
            value={customer.name}
            onChange={(e) => onChangeCustomer(e)}
        />

        <input
            className="Input"
            type="email"
            name="email"
            placeholder="Your Mail"
            value={customer.email}
            onChange={(e) => onChangeCustomer(e)}
        />

        <input
            className="Input"
            type="text"
            name="street"
            placeholder="Street"
            value={customer.street}
            onChange={(e) => onChangeCustomer(e)}
        />

        <input
            className="Input"
            type="text"
            name="postal"
            placeholder="Postal Code"
            value={customer.postal}
            onChange={(e) => onChangeCustomer(e)}
        />

        <Button click={() => {}} btnType="Success">
          ORDER
        </Button>
      </form>
    </div>
  );
};

export default ContactData;
