import ReactDOM from 'react-dom/client'
import { BrowserRouter, Route, Routes } from 'react-router-dom'
import BurgerBuilder from './containers/BurgerBuilder/BurgerBuilder'
import Checkout from './containers/Checkout/Checkout'
import ContactData from './containers/Checkout/ContactData/ContactData'
import { Provider } from 'react-redux'
import { store } from './store'
import './index.css'

ReactDOM.createRoot(document.getElementById('root') as HTMLElement).render(
  <Provider store={store}>
    <BrowserRouter>
      <Routes>
        <Route path='/' element={<BurgerBuilder />}/>
        <Route path="/checkout" element={<Checkout/>}>
          <Route path="contact-data" element={<ContactData/>}/>
        </Route>
      </Routes>
    </BrowserRouter>
  </Provider>
)
