import { configureStore } from "@reduxjs/toolkit";
import { burgerSlice } from "./slice/burger.slice";
import { contactDataSlice } from "./slice/contactData.slice";

export const store = configureStore({
    reducer: {
        burger: burgerSlice.reducer,
        contactData: contactDataSlice.reducer
    }
})

export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;
export default store;