import { IngredientNames, IngredientPrices, Ingredients } from "@/interfaces/Ingredients";
import { createSlice, PayloadAction } from "@reduxjs/toolkit";

interface IState {
    totalPrice: number
    purchasable: boolean
    open: boolean
    ingredients: Ingredients
}

const initialState: IState = {
    totalPrice: IngredientPrices.bread,
    purchasable: false,
    open: false,
    ingredients: {
        salad: 0,
        cheese: 0,
        chicken: 0,
        meat: 0
    }
}

export const burgerSlice = createSlice({
    name: 'burger',
    initialState,
    reducers: {
        setOpen(state, action: PayloadAction<boolean>) {
            state.open = action.payload
        },
        moreHandler(state, action: PayloadAction<IngredientNames>) {
            const ingKey = action.payload
            const oldCount = state.ingredients[ingKey]
            state.ingredients[ingKey] = oldCount + 1

            const priceAddition = IngredientPrices[ingKey];
            state.totalPrice += priceAddition
            
            const sum = Object.keys(state.ingredients)
                                .map(ingKey => state.ingredients[ingKey as IngredientNames])
                                .reduce((sum, el) => sum + el, 0)

            state.purchasable = sum > 0
        },
        lessHandler(state, action: PayloadAction<IngredientNames>) {
            const ingKey = action.payload
            const oldCount = state.ingredients[ingKey]

            if (oldCount <= 0) return;

            state.ingredients[ingKey] = oldCount - 1
            const priceAddition = IngredientPrices[ingKey];
            state.totalPrice -= priceAddition

            const sum = Object.keys(state.ingredients)
                        .map(ingKey => state.ingredients[ingKey as IngredientNames])
                        .reduce((sum, el) => sum + el, 0)

            state.purchasable = sum > 0
        }
    }
})

export const {setOpen, moreHandler, lessHandler} = burgerSlice.actions