import axiosBase from "@/config/axiosBase";
import { IConactData, ICustomer } from "@/interfaces/checkout";
import { createAsyncThunk, createSlice, PayloadAction } from "@reduxjs/toolkit";

interface IState {
    loading: boolean
    error: string | null
    customer: ICustomer
}

const initialState: IState = {
    loading: false,
    error: null,
    customer: {
        name: '',
        email: '',
        street: '',
        postal: ''
    }
}

export const postContactData = createAsyncThunk(
    'contact/postContactData',
    async (data: IConactData) => {
        try {
            await axiosBase.post('orders.json', data) 
        } catch {
            throw new Error('Unknown error')
        }
    }
)

export const contactDataSlice = createSlice({
    name: 'contact',
    initialState,
    reducers: {
        setCustomer: (state, action: PayloadAction<{name: string, value: string}>): void => {
            const {name, value} = action.payload;
            
            switch (name) {
                case 'name':
                    state.customer.name = value
                    break
                case 'email': 
                    state.customer.email = value
                    break
                case 'postal':
                    state.customer.postal = value
                    break
                case 'street': 
                    state.customer.street = value
                    break
                default:
                    break;
            }
        }
    },
    extraReducers(builder) {
        builder
            .addCase(postContactData.pending, (state) => {
                state.loading = true
                state.error = null
            })
            .addCase(postContactData.rejected, (state, action) => {
                state.loading = false
                state.error = action.error.message || ''
            })
            .addCase(postContactData.fulfilled, (state) => {
                state.loading = false
                state.error = null
            })
    },
})

export const {setCustomer} = contactDataSlice.actions