import React, {useState, useEffect, useCallback} from "react";
import { useNavigate } from "react-router-dom";
import axiosBurger from "@/config/axiosBurger";
import { parseGetOrders } from "@/helpers/parseGetOrders";
import { TOrder } from "@/interfaces/order";
import { OrderItem } from "@/components/Order/OrderItem/OrderItem";
import { Spinner } from "@/components/UI/Spinner/Spinner";
import withSpinnerHandler from "@/hoc/withSpinnerHandler";

const Orders = () => {
    const navigate = useNavigate();

    const [orders, setOrders] = useState<TOrder[]>([]);

    const getOrders = useCallback(async () => {
        const {data} = await axiosBurger.get("orders");
        setOrders(parseGetOrders(data).reverse());
    }, []);

    useEffect(() => {
        getOrders();
    }, []);

    const onClickHandler = (id: string) => {
        navigate({
            pathname: `/order`
        })
    };
    
    return (
        <>
            {
                orders.map(order => (
                    <OrderItem
                        onClick={() => onClickHandler(order.id)}
                        key={order.id}
                        ingredients={order.ingredients}
                        price={order.price}
                    />
                ))
            }
        </>
    );
};


export default withSpinnerHandler(Orders, axiosBurger)