import { Ingredients } from "./Ingredients";
import { TContactData } from "./contactData"

export interface IGetOrder<T> {
    [key: string]: T
};

export type TOrder = {
    id?: string,
    contactData: TContactData,
    price: number,
    ingredints: Ingredients,
};

export type TOrderState = {
    contactData: TContactData | null,
    price: number | null,
    ingredients: Ingredients | null,
    isLoading: boolean,
    error: null | Error
}