import React from 'react';
import { BrowserRouter, Routes, Route } from 'react-router-dom';
import BurgerBuilder from './containers/BurgerBuilder/BurgerBuilder';
import { Checkout } from './containers/Checkout/Checkout';
import { NotFound } from './components/NotFound/NotFound';
import { ContactData } from './containers/ContactData/ContactData';

function App() {
  return (
    <BrowserRouter>
      <Routes>
        <Route path='/' element={<BurgerBuilder/>}/>
        <Route path='/checkout' element={<Checkout/>}>
          <Route path='contactData' element={<ContactData/>}/>
        </Route>
        <Route path='*' element={<NotFound/>}/>
      </Routes>
    </BrowserRouter>
  )
}

export default App
