import React, {useState, useEffect, useCallback} from "react";
import { useNavigate } from "react-router-dom";
import axiosBurger from "@/config/axiosBurger";
import { parseGetOrders } from "@/helpers/parseGetOrders";
import { TOrder } from "@/interfaces/order";
import { OrderItem } from "@/components/Order/OrderItem/OrderItem";
import { Spinner } from "@/components/UI/Spinner/Spinner";

export const Orders = () => {
    const navigate = useNavigate();

    const [orders, setOrders] = useState<TOrder[]>([]);
    const [isLoading, setIsLoading] = useState<boolean>(false);

    const getOrders = useCallback(async () => {
        setIsLoading(true);
        const {data} = await axiosBurger.get("orders.json");
        setOrders(parseGetOrders(data).reverse());
        setIsLoading(false);
    }, []);

    useEffect(() => {
        getOrders();
    }, []);

    const onClickHandler = (id: string) => {
        navigate({
            pathname: `/order`
        })
    };
    
    return (

        <>
            <Spinner show={isLoading}/>
            {
                orders.map(order => (
                    <OrderItem
                        onClick={() => onClickHandler(order.id)}
                        key={order.id}
                        ingredients={order.ingredients}
                        price={order.price}
                    />
                ))
            }
        </>
    );
};