import { createSlice } from "@reduxjs/toolkit";
import { IngredientNames, Ingredients } from "@/interfaces/Ingredients";

const initialState: Ingredients = {
    salad: 0,
    meat: 0,
    bacon: 0,
    cheese: 0
};

export const ingredientsSlice = createSlice({
    name: "ingredients",
    initialState,
    reducers: {
        setIngredients(state, action) {
            const {ingType, actionType} = action.payload as {ingType: IngredientNames, actionType: string}

            if(actionType === "more") {
                state[ingType] += 1
            } else if(actionType === "less") {
                if(state[ingType] > 0) {
                    state[ingType] -= 1
                }
            }
        }
    }
});

export const {setIngredients} = ingredientsSlice.actions;