import React, { MouseEventHandler, ReactNode } from "react";
import "./Button.css";

type TProps = {
    children: ReactNode;
    click: MouseEventHandler<HTMLButtonElement>;
    btnType: 'Success' | 'Danger';
}

export const Button = ({click, btnType, children}: TProps) => {
    return (
        <button
            onClick={click}
            className={['Button', btnType].join(' ')}
        >
            {children}
        </button>
    )
};