import React, {useRef} from 'react';
import {useSearchParams, Outlet, useNavigate} from "react-router-dom";
import type {Ingredients} from '@/interfaces/Ingredients';
import { CheckoutSummary } from '@/components/Order/CheckoutSummary/CheckoutSummary';
import { parseParams } from '@/helpers/parseParams';

export const Checkout = () => {
  const navigate = useNavigate();
  const [params] = useSearchParams();

  const ingredients = useRef(parseParams<Ingredients>(params));

  const checkoutCancelledHandler = () => {
    navigate(-1);
  };

  const checkoutContinuedHandler = () => {
    navigate('contactData', {state: {ingredients: ingredients.current}});
  };

  return (
    <>
        <CheckoutSummary 
            ingredients={ingredients.current}
            checkoutCancelled={checkoutCancelledHandler}
            checkoutContinued={checkoutContinuedHandler}
        />
        <Outlet/>
    </>
);
};