import React from 'react';
import {Outlet, useNavigate} from "react-router-dom";
import { CheckoutSummary } from '@/components/Order/CheckoutSummary/CheckoutSummary';
import { useAppSelector } from '@/store';

export const Checkout = () => {
  const navigate = useNavigate();
  const {ingredints} = useAppSelector(state => state);

  const checkoutCancelledHandler = () => {
    navigate(-1);
  };

  const checkoutContinuedHandler = () => {
    navigate('contactData');
  };

  return (
    <>
        <CheckoutSummary 
            ingredients={ingredints}
            checkoutCancelled={checkoutCancelledHandler}
            checkoutContinued={checkoutContinuedHandler}
        />
        <Outlet/>
    </>
);
};