import React, { useState, FunctionComponent, useEffect } from 'react';
import { AxiosInstance, AxiosResponse, AxiosError } from 'axios';
import { Modal } from '@/components/UI/Modal/Modal';

const withSpinnerHandler = <T extends object>(WrappedComponent: FunctionComponent<T>, axios: AxiosInstance) => {
    return (props: T) => {
        const [error, setError] = useState<string>("");
        const [show, setShow] = useState<boolean>(false)

        const succesHandler = async (res: AxiosResponse<any, any>) => {
            return res
        };

        const rejectHandler = (rej: AxiosError<any, any>) => {
            setError(rej.message)
            setShow(true)
            return rej
        };

        const onClosedHandler = () => {
            setShow(false)
        };

        useEffect(() => {
            axios.interceptors.response.use(succesHandler, rejectHandler);
        }, []);

        return (
            <>
                <Modal show={show} onClosed={onClosedHandler}>
                    <h1>{error}</h1>
                </Modal>
                <WrappedComponent {...props} />
            </>
        );
    };
};
  
export default withSpinnerHandler;