import { configureStore } from "@reduxjs/toolkit";
import { TypedUseSelectorHook, useDispatch, useSelector } from "react-redux";
import { ingredientsSlice } from "./ingredients.slice";
import { ordersSlice } from "./orders.slice";

export const store = configureStore({
    reducer: {
        ingredints: ingredientsSlice.reducer,
        orders: ordersSlice.reducer
    }
});

type RootState = ReturnType<typeof store.getState>;
type AppDispatch = typeof store.dispatch;

export const useAppDispatch: () => AppDispatch = useDispatch
export const useAppSelector: TypedUseSelectorHook<RootState> = useSelector