import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { TOrder, TOrderState } from "@/interfaces/order";
import axiosBurger from "@/config/axiosBurger";

const initialState: TOrderState = {
    ingredients: null,
    price: null,
    contactData: null,
    isLoading: false,
    error: null
};

export const postOrder = createAsyncThunk(
    "orders/postOrder",
    async (order: TOrder) => {
        try {
            const data = await axiosBurger.post("orders.json", order)
            return data
        } catch (error: any) {
            throw new Error(error)
        }
    }
)

export const getOrder = createAsyncThunk(
    "orders/getOrder",
    async () => {
        try {
            const data = await axiosBurger.get("orders.json")
            return data
        } catch (error: any) {
            throw new Error(error)
        }
    }
)

export const ordersSlice = createSlice({
    name: "orders",
    initialState,
    reducers: {

    },
    extraReducers: builder => {
        builder
        .addCase(postOrder.pending, (state) => {
            state.isLoading = true
            console.log("PENDING");
            
        })
        .addCase(postOrder.rejected, (state, action) => {
            state.isLoading = false
            state.error = action.error as Error
            console.log("REJECT");
            
        })
        .addCase(postOrder.fulfilled, (state, action) => {
            const {ingredients, price, contactData} = action.payload as any
            console.log(action.payload, "FULFILLED");
            
            state.isLoading = false
            state.ingredients = ingredients
            state.contactData = contactData
            state.price = price
        })

        .addCase(getOrder.pending, (state) => {
            state.isLoading = true
            console.log("PENDING");
            
        })
        .addCase(getOrder.rejected, (state, action) => {
            state.isLoading = false
            state.error = action.error as Error
            console.log("REJECT");
            
        })
        .addCase(getOrder.fulfilled, (state, action) => {
            console.log(action.payload, "FULFILLED");
            state.isLoading = false
        })
    }
});