import {useEffect, useState, useCallback} from 'react'
import {Row, Card, Spin, Modal, Typography} from 'antd'
import { IPost } from '../Interfaces/IPost'
import { IUser } from '../Interfaces/IUser'
import { ApiConnector } from '../Integrations/api.connector'

const jsonConnector = new ApiConnector('https://jsonplaceholder.typicode.com')

const App = () => {
  const [posts, setPosts] = useState<IPost[]>([])
  const [authorId, setAuthorId] = useState<number | null>(null)
  const [author, setAuthor] = useState<IUser | null>(null)
  const [loading, setLoading] = useState<boolean>(false)
  const [open, setOpen] = useState<boolean>(false)

  const getPosts = useCallback(async () => {
    setLoading(true)
    const res = await jsonConnector.getPosts()
    setPosts(res)
    setLoading(false)
  }, [])

  const getAuthor = useCallback(async () => {
    setLoading(true)
    const res = await jsonConnector.getAuthor(authorId)
    setAuthor(res)
    setLoading(false)
  }, [authorId])

  const onClickHandler = (id: number) => {
    setAuthorId(id)
  }

  useEffect(() => {
    getPosts()
  }, [getPosts])

  useEffect(() => {
    if(authorId) getAuthor()
  }, [authorId, getAuthor])

  return (
    <Row 
      align={'top'} 
      justify={'space-between'}
      style={{
        width: '100%',
        backgroundColor: 'gray'
      }}
    >
      <Modal
        open={open}
        onCancel={() => setOpen(false)}
      >
        <Typography>
          {author?.name}
        </Typography>
        <Typography>
          {author?.phone}
        </Typography>
        <Typography>
          {author?.email}
        </Typography>
      </Modal>

      <Spin spinning={loading}>
        <Row 
          align={'top'} 
          justify={'space-between'}
          style={{
            gap: '15px',
            padding: '15px'
          }}
        > 
          {
            posts?.map(post => (
              <Card
                key={post?.id}
                title={post?.title}
                style={{ width: 300, cursor: 'pointer' }}
                onClick={() => onClickHandler(post.userId)}
              >
                {post?.body}
              </Card>
            ))
          }
        </Row>
      </Spin>
    </Row>
  )
}

export default App