import { notification } from "antd";
import axios from "axios";

export class ApiConnector {
    private url: string
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    private axiosBase: any

    constructor(url: string) {
        this.url = url
        this.axiosBase = axios
        this.init()
    }

    init() {
        this.axiosBase = axios.create({
            baseURL: this.url
        })
    }

    public async getPosts() {
        try {
            const {data} = await this.axiosBase('/posts')
            return data
        } catch {
            notification.error({
                message: 'Запрос сломался'
            })
        }
    }

    public async getAuthor(id: number | null) {
        try {
            const {data} = await this.axiosBase(`/users/${id}`)
            return data
        } catch {
            notification.error({
                message: 'Запрос сломался'
            })
        }
    }
}