import { axiosBase } from "../Config/axiosBase"
import { notification } from 'antd'
import { IHome } from "../Interfaces/home"
import { IAboutMe } from "../Interfaces/aboutMe"
import { IEducation } from "../Interfaces/education"

class ApiConnector {
    public static async getHome() {
        try {
            const {data} = await axiosBase.get<Promise<IHome>>('home.json')
            return data
        } catch {
            notification.error({
                message: 'Ошибка при запросе на HOME'
            })
        }
    }

    public static async getAboutMe() {
        try {
            const {data} = await axiosBase.get<Promise<IAboutMe>>('aboutme.json')
            return data
        } catch {
            notification.error({
                message: 'Ошибка при запросе на ABOUT ME'
            })
        }
    } 

    public static async getEducations() {
        try {
            const {data} = await axiosBase.get<Promise<IEducation>>('educations.json')
            return data
        } catch {
            notification.error({
                message: 'Ошибка при запросе на EDUCATIONS'
            })
        }
    }

    public static async getEducation(id?: string) {
        try {
            const {data} = await axiosBase.get<Promise<string>>(`educations/${id}.json`)
            return data
        } catch {
            notification.error({
                message: 'Ошибка при запросе на EDUCATION'
            })
        }
    }
}

export default ApiConnector