import { useEffect, useState } from "react"
import ApiConnector from "../../Integrations/api.connector"
import { IAboutMe } from "../../Interfaces/aboutMe"
import { Row, Typography } from "antd"

const AboutMe = () => {
    const [aboutMe, setAboutMe] = useState<IAboutMe | null>(null)

    const getData = async () => {
        const data = await ApiConnector.getAboutMe()
        setAboutMe(data || null)
    }

    useEffect(() => {
        getData()
    }, [])

    return (
        <Row>
            <Typography.Title>
                {aboutMe?.info}
            </Typography.Title>
        </Row>
    )
}

export default AboutMe