import {BrowserRouter, Routes, Route} from 'react-router-dom'
import Home from './Home/Home'
import AboutMe from './AboutMe/AboutMe'
import Educations from './Educations/Educations'
import Education from './Education/Education'
import CustomeLayout from './Layout/Layout'

const App = () => (
  <BrowserRouter>
    <Routes>
      <Route path='/' element={<CustomeLayout/>}>
        <Route index element={<Home/>}/>
        <Route path='/aboutMe' element={<AboutMe/>}/>
        <Route path='/education' element={<Educations/>}/>
        <Route path='/education/:id' element={<Education/>}/>
      </Route>
    </Routes>
  </BrowserRouter>
)

export default App