import { useEffect, useState } from "react"
import ApiConnector from "../../Integrations/api.connector"
import { useParams } from "react-router-dom"
import { Row, Typography } from "antd"

const Education = () => {
  const {id} = useParams()
  const [text, setText] = useState<string | null>(null)

  const getData = async () => {
    const data = await ApiConnector.getEducation(id)
    setText(data || null)
  }

  useEffect(() => {
    getData()
  }, [id])

  return (
    <Row>
      <Typography.Title>
        {text}
      </Typography.Title>
    </Row>
  )
}

export default Education