import { useEffect, useState } from "react"
import ApiConnector from "../../Integrations/api.connector"
import { IEducations } from "../../Interfaces/education"
import { parserEducations } from "../../Helpers/parserEducations"
import { Button, Card, Row } from "antd"
import { useNavigate } from "react-router-dom"

const Educations = () => {
  const navigate = useNavigate()
  const [educations, setEducations] = useState<IEducations[]>([])

  const getData = async () => {
    const data = await ApiConnector.getEducations()
    const parse = parserEducations(data)
    setEducations(parse)
  }

  const onClickReadMore = (id?: string) => {
    navigate(`/education/${id}`)
  }

  useEffect(() => {
    getData()
  }, [])

  return (
    <Row>
      {
        educations?.map((item) => (
          <Card
            key={item?.id}
            title={item?.value}
          >
            <Button 
              type={'primary'}
              onClick={() => onClickReadMore(item?.id)}
            >
              Read more
            </Button>
          </Card>
        ))
      }
    </Row>
  )
}

export default Educations